class Database{
    constructor(identifier){
        /**
         * This Database's unique identifier
         */
        Object.defineProperty(this, "id", {value:identifier, writable: false});
    }
    /**
     * Sets a new table
     * @param {string} name The new table's key
     * @returns {Map}
     */
    newTable(name){
        if(name == ""){
            console.log("New Table name cannot be \"\"! Return undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                console.log("New Table's name already used! Returns undefined"); return undefined;
            }else {
                this.table.set(name, new Map());
                console.log("New Table succesfully set! Returns "+name); return this.table.get(name);
            };
        };
    };
    /**
     * Gets a Table
     * @param {string} name The table's name to get
     */
    getTable(name){
        if(name==""){
            console.log("Table name not allowed! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                console.log("Table found! Returns table "+name); return this.table.get(name);
            }else {
                console.log("Table not found! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Sets a value in a given table
     * @param {string} name Table name (key)
     * @param {string} key Table's value (key) to set
     * @param {string|number|Array|any} value The value to set to
     * @returns {undefined|string|number|Array|any}
     */
    setInTable(name, key, value){
        if(name == "" || key == "" || value == ""){
            console.log("Given \"\"! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                if(this.table.get(name).has(key)){
                    console.log("Table value set! Returns value"); this.table.get(name).set(key, value); return this.table.get(name).get(key);
                }else {
                    console.log("Table value not found! Returns undefined"); return undefined;
                };
            }else {
                console.log("Table not found! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Sets a value in a given table
     * @param {string} name Table name (key)
     * @param {string} key Table's value (key) to set
     * @param {string|number|Array|any} value The value to set to
     * @returns {undefined|string|number|Array|any}
     */
    newKeyInTable(name, key, value){
        if(name == "" || key == ""){
            console.log("Given \"\"! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                if(this.table.get(name).has(key)){
                    console.log("Table value already set! Returns table");return this.table.get(name).get(key);
                }else {
                    this.table.get(name).set(key, value);
                    console.log("New Table value set! Returns table"); return this.table.get(name).get(key);
                };
            }else {
                console.log("Table not found! Returns undefined"); return this.table.get(name).set(key, value);
            };
        };
    };
    /**
     * Deletes a table
     * @param {string} name The table to delete
     * @returns {undefined|Map}
     */
    deleteTable(name){
        if(name == ""){
            console.log("Given \"\" as table name! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                let ov = this.table.get(name); this.table.delete(name); console.log("Succesfully deleted Table! Returns "+name); return ov;
            }else {
                console.log("Table to delete not found! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Deletes a value (key) in a given table
     * @param {string} name The table the key is located in
     * @param {string} key The key to delete
     * @returns {undefined|void}
     */
    deleteInTable(name, key){
        if(name == ""){
            console.log("Given \"\" as table name! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                this.table.get(name).delete(key);
            }else {
                console.log("Given key does not exist inn table! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Loads the data from a saved Json table string
     * @param {string} tables A JSON saved Map in string
     */
    loadSaveString(tables) {
        let r = JSON.parse(tables);
        for(let key = 0; key < r.length; key++){
            this.table.set(r[key][0], new Map(Object.entries(r[key][1])));
        };
        console.log("Loaded Database set")
        return this.table;
    };
    /**
     * Returns a JSON string of the table data
     * @returns {string} A string that can be loaded with Database.loadSaveString()
     */
    getSaveString() {
        let vals = [];
        this.table.forEach((val)=>{
            let jsonF = Object.fromEntries(val);
            //console.log(jsonF); 	    // {k:v}
            vals.push(jsonF);
        });
        let keys = Array.from(this.table.keys());
        let r = [];
        for(let k = 0; k < keys.length; k++){
            let pair = [keys[k], vals[k]];
            //console.log(pair);
            r.push(pair);
        };
        return JSON.stringify(r);
    };
    /**
     * Gets a key's value in a table
     * @param {string} name The table to look in for
     * @param {string} key The key in the table to look for
     * @returns {undefined|any}
     */
    getInTable(name, key){
        if(this.table.has(name)){
            if(this.table.get(name).has(key)){
                return this.table.get(name).get(key);
            }else {
                console.log("Key not found! Returns undefined"); return undefined;
            };
        }else {
            console.log("Table not found! Returns undefined, searched "+name); return undefined;
        };
    };
    /**
     * Saves the Database inside an object's dynamic property
     * @param {string} property The dynamic property's identifier
     * @param {any} object The object to save in
     */
    saveDatabase(property, object){
        object.setDynamicProperty(property, this.getSaveString());
        if(object instanceof World){
            console.warn("Saved Database in World Dynamic Properties as "+property);
        }else {
            console.warn("Saved Database in Entity with Id "+ object.id+" as "+ property);
        };
    };
    /**
     * @type {Map<string, Map<string, string|number|Array>>}
     */
    table = new Map();
};